using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Krzysztof Dobranowski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>01/12/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// ExceptionReport data access layer class.
	///</summary>

	#endregion
	
	public class ExceptionReport
	{

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4173"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4174"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionLabelMismatch table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportLabelMismatch(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportLabelMismatch.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportLabelMismatch.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportLabelMismatch.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportLabelMismatch.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportLabelMismatch";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportLabelMismatch";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5767"> 
		///		<ExpectedInput>Valid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet of Exceptions for Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5768"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionLabelMismatch table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportLabelMismatch(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportLabelMismatchForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportLabelMismatchForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportLabelMismatchForBloodUnit.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportLabelMismatch";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportLabelMismatch";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4175"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4176"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAboRh table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAboRH(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRh.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRh.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRh.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAboRh.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientAboRh";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAboRh";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2077"> 
		///		<ExpectedInput>division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2081"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAboRh table used to generate the exception report for a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAboRH(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRhForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRhForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAboRhForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientAboRh";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAboRh";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4177"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4178"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAboRhDiscrepancy table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAboRHDiscrepancy(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancy.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancy.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancy.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancy.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportPatientAboRhDiscrepancy";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAboRhDiscrepancy";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2082"> 
		///		<ExpectedInput>division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2083"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAboRhDiscrepancy table used to generate the exception report for a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAboRHDiscrepancy(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancyForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancyForPatient.patientguid , SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAboRHDiscrepancyForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientAboRhDiscrepancy";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAboRhDiscrepancy";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4179"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4180"> 
		///		<ExpectedInput>division code, invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAntigenDiscrepancy table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAntigenDiscrepancy(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancy.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancy.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancy.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancy.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportPatientAntigenDiscrepancy";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAntigenDiscrepancy";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2084"> 
		///		<ExpectedInput>division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2086"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientAntigenDiscrepancy table used to generate the exception report for a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientAntigenDiscrepancy(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancyForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancyForPatient.patientguid , SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientAntigenDiscrepancyForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientAntigenDiscrepancy";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientAntigenDiscrepancy";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4181"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4182"> 
		///		<ExpectedInput>division code, invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionPatientTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientTest(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTest.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTest.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTest.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientTest.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientTest";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2089"> 
		///		<ExpectedInput>division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2090"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientTest(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestForPatient.patientguid , SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientTestForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientTest";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4183"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4184"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionPatientTestInactivated table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientTestInactivated(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestInactivated.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestInactivated.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestInactivated.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientTestInactivated.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientTestInactivated";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientTestInactivated";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2091"> 
		///		<ExpectedInput>division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2092"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionPatientTestInactivated table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientTestInactivated(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestInactivatedForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportPatientTestInactivatedForPatient.patientguid , SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientTestInactivatedForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientTestInactivated";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientTestInactivated";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2095"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2096"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///     Gets the data for the incoming shipment exception of receiving an expired unit
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportExpiredUnitReceived(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredUnitReceived.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredUnitReceived.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredUnitReceived.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportExpiredUnitReceived.StoredProcName, prms);

			ds.DataSetName = "GetExceptionReportExpiredUnitReceived";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "GetExceptionReportExpiredUnitReceived";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4185"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4186"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQC table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQC(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQC.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQC.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportQC.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQC.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQC";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQC";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/21/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8375"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet with data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8376"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty Dataset</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQC table used to generate the exception report
		/// for a blood unit
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQC(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQcForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQcForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQcForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQC";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQC";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Software Architectects Inc.</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/21/2006</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8398"> 
		///		<ExpectedInput>DivisionCode, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet with data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8399"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionQC table used to generate the exception report
		/// for a patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient Guid</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQC(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQcForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQcForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQcForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQC";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQC";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4187"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4188"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQcInactivation table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQCInactivated(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQCInactivated.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQCInactivated.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportQCInactivated.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQCInactivated.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportQCInactivated";

			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.VbecsTables.ExceptionQcInactivation.TableName;
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4189"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4190"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQCNotPerformed table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQCNotPerformed(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQcNotPerformed.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQcNotPerformed.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportQcNotPerformed.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQcNotPerformed.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQCNotPerformed";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQCNotPerformed";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2100"> 
		///		<ExpectedInput>division code, patientguid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2101"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionQCNotPerformed table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQCNotPerformed(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQcNotPerformedForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQcNotPerformedForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQcNotPerformedForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQCNotPerformed";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQCNotPerformed";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4191"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4192"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQuarantine table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQuarantine(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantine.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantine.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantine.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQuarantine.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQuarantine";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQuarantine";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2105"> 
		///		<ExpectedInput>division code, patientguid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2106"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionQuarantine table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQuarantine(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantineForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantineForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQuarantineForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQuarantine";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQuarantine";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5769"> 
		///		<ExpectedInput>Valid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5770"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionQuarantine table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportQuarantine(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantineForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportQuarantineForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportQuarantineForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportQuarantine";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportQuarantine";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4193"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4194"> 
		///		<ExpectedInput>division code, invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionReflexTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportReflexTest(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportReflexTest.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportReflexTest.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportReflexTest.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportReflexTest.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportReflexTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportReflexTest";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2107"> 
		///		<ExpectedInput>division code, patientguid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2108"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionReflexTest table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportReflexTest(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportReflexTestForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportReflexTestForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportReflexTestForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportReflexTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportReflexTest";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4195"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4196"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionSpecimen table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportSpecimen(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportSpecimen.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportSpecimen.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportSpecimen.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportSpecimen.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportSpecimen";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportSpecimen";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2109"> 
		///		<ExpectedInput>division code, patientguid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2110"> 
		///		<ExpectedInput>invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionSpecimen table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportSpecimen(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportSpecimenForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportSpecimenForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportSpecimenForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportSpecimen";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportSpecimen";
				return ds;
			}
			else
				return new DataSet();
		}
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4197"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4198"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitAboRh table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitAboRH(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitAboRh.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitAboRh.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitAboRh.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;


			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitAboRh.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitAboRh";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitAboRh";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5773"> 
		///		<ExpectedInput>Valid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5774"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitAboRh table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitAboRH(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitAboRhForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitAboRhForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitAboRhForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitAboRh";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitAboRh";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4199"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4200"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitModification table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitModification(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitModification.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitModification.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitModification.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitModification.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitModification";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitModification";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5775"> 
		///		<ExpectedInput>Valid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5776"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitModification table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitModification(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitModificationForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitModificationForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitModificationForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitModification";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitModification";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4201"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4202"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitSelection table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitSelection(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelection.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelection.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelection.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitSelection.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitSelection";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitSelection";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2111"> 
		///		<ExpectedInput>Valid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2112"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionUnitSelection table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitSelection(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelectionForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelectionForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitSelectionForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitSelection";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitSelection";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5771"> 
		///		<ExpectedInput>Valid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5772"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty Dataset</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionUnitSelection table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitSelection(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelectionForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSelectionForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitSelectionForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitSelection";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitSelection";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8029"> 
		///		<ExpectedInput>Valid division code, date parameters</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8030"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty Dataset</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionRemoveUnitStatus table used to generate the exception report
		/// for a supplied date range
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate" type="System.DateTime"></param>
		/// <param name="endDate" type="System.DateTime"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportRemoveFinalUnitStatus(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportRemoveFinalUnitStatus.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportRemoveFinalUnitStatus.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportRemoveFinalUnitStatus.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportRemoveFinalUnitStatus.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString();
				return ds;
			}
			else
				return new DataSet();
		}



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8025"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8026"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionRemoveUnitStatus table used to generate the exception report
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportRemoveFinalUnitStatus(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportRemoveFinalUnitStatusForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportRemoveFinalUnitStatusForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportRemoveFinalUnitStatusForBloodUnit.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString();
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4791"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4792"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportReturnIssuedUnit
		/// </summary>
		/// <param name="divisionCode" type="string"></param>
		/// <param name="startDate" type="System.DateTime"></param>
		/// <param name="endDate" type="System.DateTime"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportReturnIssuedUnit(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnit.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnit.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportReturnIssuedUnit.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString();
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2113"> 
		///		<ExpectedInput>Valid Division, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2114"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionReturnedUnit table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportReturnIssuedUnit(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnitForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnitForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportReturnIssuedUnitForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportReturnIssuedUnit";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportReturnIssuedUnit";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5777"> 
		///		<ExpectedInput>Valid BloodUnitGUid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5778"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionReturnedUnit table used to generate the exception report fr a single patient
		/// for a particular blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportReturnIssuedUnit(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnitForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportReturnIssuedUnitForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportReturnIssuedUnitForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportReturnIssuedUnit";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportReturnIssuedUnit";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4811"> 
		///		<ExpectedInput>division code, start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4812"> 
		///		<ExpectedInput>invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///     GetExceptionReportAboIncompatibleTransfusion
		/// </summary>
		/// <param name="divisionCode" type="string"></param>
		/// <param name="startDate" type="System.DateTime"></param>
		/// <param name="endDate" type="System.DateTime"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportAboIncompatibleTransfusion(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportAboIncompatibleTransfusion.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportAboIncompatibleTransfusion.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportAboIncompatibleTransfusion.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportAboIncompatibleTransfusion.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportAboIncompatibleTransfusion";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportAboIncompatibleTransfusion";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2115"> 
		///		<ExpectedInput>Valid patientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2116"> 
		///		<ExpectedInput>Invalid patientguid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the data from ExceptionTransfusion table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportAboIncompatibleTransfusion(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] par = new SqlParameter[2];
			par[0] = new SqlParameter(STOREDPROC.GetExceptionReportAboIncompatibleTransfusionForPatient.divisioncode, divisionCode);
			par[0].DbType = DbType.String;
			par[1] = new SqlParameter(STOREDPROC.GetExceptionReportAboIncompatibleTransfusionForPatient.patientguid, patientGuid);
			par[1].DbType = DbType.Guid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportAboIncompatibleTransfusionForPatient.StoredProcName, par);
			ds.DataSetName = "ExceptionReportAboIncompatibleTransfusion";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportAboIncompatibleTransfusion";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5884"> 
		///		<ExpectedInput>Valid division code, start and end dates</ExpectedInput>
		///		<ExpectedOutput>Valid DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5885"> 
		///		<ExpectedInput>empty division code</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="0" testid ="5898"> 
		///		<ExpectedInput>Start date set to Minimum value</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5899"> 
		///		<ExpectedInput>End date set to Minimum value</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportCautionTagBTRF
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportCautionTagBTRF(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportCautionTagBTRF.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportCautionTagBTRF.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportCautionTagBTRF.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportCautionTagBTRF.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportCautionTagBTRF";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportCautionTagBTRF";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8027"> 
		///		<ExpectedInput>DivisionCode, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8028"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportCautionTagBTRF
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportCautionTagBTRF(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(STOREDPROC.GetExceptionReportCautionTagBtrfForPatient.divisioncode, divisionCode),
					new SqlParameter(STOREDPROC.GetExceptionReportCautionTagBtrfForPatient.patientguid, patientGuid)
				};

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportCautionTagBtrfForPatient.StoredProcName, parms);
			ds.DataSetName = Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString();

			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString();
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6510"> 
		///		<ExpectedInput>Division Code, date range parameters</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6511"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportUnitIssue
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitIssue(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitIssue.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitIssue.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitIssue.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitIssue.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportUnitIssue";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitIssue";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}




		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7989"> 
		///		<ExpectedInput>Division Code Date Range parameters</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7990"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetExceptionReportEmergencyIssueOrder
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportEmergencyIssueOrder(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueOrder.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueOrder.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueOrder.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportEmergencyIssueOrder.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportEmergencyIssueOrder";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportEmergencyIssueOrder";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7991"> 
		///		<ExpectedInput>Division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7992"> 
		///		<ExpectedInput>Invalid patientguid</ExpectedInput>
		///		<ExpectedOutput>Argument Exception</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportEmergencyIssueOrder
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportEmergencyIssueOrder(string divisionCode, Guid patientGuid)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (patientGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("patient guid").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueOrderForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueOrderForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportEmergencyIssueOrderForPatient.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportEmergencyIssueOrder";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportEmergencyIssueOrder";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7993"> 
		///		<ExpectedInput>Division Code, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7994"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportUnitIssue
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitIssue(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(STOREDPROC.GetExceptionReportUnitIssueForPatient.divisioncode, divisionCode),
					new SqlParameter(STOREDPROC.GetExceptionReportUnitIssueForPatient.patientguid, patientGuid)
				};

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitIssueForPatient.StoredProcName, parms);
			ds.DataSetName = "ExceptionReportUnitIssue";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitIssue";
				return ds;
			}
			else
				return new DataSet();
		}



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7995"> 
		///		<ExpectedInput>Division, Date range parameters</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7996"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportTrwSpecimen
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTrwSpecimen(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportTrwSpecimen.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportTrwSpecimen.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportTrwSpecimen.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTrwSpecimen.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportTrwSpecimen";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportTrwSpecimen";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7997"> 
		///		<ExpectedInput>Division, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7998"> 
		///		<ExpectedInput>Invalid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionTrwSpecimen table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTrwSpecimen(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(STOREDPROC.GetExceptionReportTrwSpecimenForPatient.divisioncode, divisionCode),
					new SqlParameter(STOREDPROC.GetExceptionReportTrwSpecimenForPatient.patientguid, patientGuid)
				};

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTrwSpecimenForPatient.StoredProcName, parms);
			ds.DataSetName = "ExceptionReportTrwSpecimen";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportTrwSpecimen";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7999"> 
		///		<ExpectedInput>Division code, valid date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8000"> 
		///		<ExpectedInput>Invalid Dates</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportTransfusionReactionWorkup
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTransfusionReactionWorkup(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}

			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionReactionWorkup.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionReactionWorkup.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionReactionWorkup.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTransfusionReactionWorkup.StoredProcName, prms);
			ds.DataSetName = "ExceptionReportTransfusionReactionWorkup";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportTransfusionReactionWorkup";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8001"> 
		///		<ExpectedInput>Division code, patient Guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8002"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionTransfusionReactionWorkup table used to generate the exception report fr a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTransfusionReactionWorkup(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(STOREDPROC.GetExceptionReportTransfusionReactionWorkupForPatient.divisioncode, divisionCode),
					new SqlParameter(STOREDPROC.GetExceptionReportTransfusionReactionWorkupForPatient.patientguid, patientGuid)
				};

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTransfusionReactionWorkupForPatient.StoredProcName, parms);

			ds.DataSetName = "ExceptionReportTransfusionReactionWorkup";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportTransfusionReactionWorkup";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8003"> 
		///		<ExpectedInput>Division code, date range</ExpectedInput>
		///		<ExpectedOutput>DateRange</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8004"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportAntigenTestInvalidated
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportAntigenTestInvalidated(string divisionCode, DateTime startDate, DateTime endDate)
		{
			if (divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("division code").ResString);
			}
			if (startDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("start date").ResString);
			}
			if (endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("end date").ResString);
			}
			//
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportAntigenTestInvalidated.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportAntigenTestInvalidated.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportAntigenTestInvalidated.enddate, SqlDbType.DateTime)
								  };
			//
			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;
			//
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportAntigenTestInvalidated.StoredProcName, prms);
			ds.DataSetName = "ExceptionAntigenTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionAntigenTest";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8005"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8006"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionReportAntigenTest table used to generate the exception report for a single unit
		/// </summary>
		/// <param name="bloodUnitGuid">Blood unit unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportAntigenTestInvalidated(Guid bloodUnitGuid)
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(STOREDPROC.GetExceptionReportAntigenTestInvalidatedForBloodUnit.divisioncode, Common.LogonUser.LogonUserDivisionCode),
					new SqlParameter(STOREDPROC.GetExceptionReportAntigenTestInvalidatedForBloodUnit.bloodunitguid, bloodUnitGuid)
				};
			//
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportAntigenTestInvalidatedForBloodUnit.StoredProcName, parms);
			//
			ds.DataSetName = "ExceptionAntigenTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionAntigenTest";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8007"> 
		///		<ExpectedInput>Division code, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8008"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionPatientTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitTest(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitTest.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitTest.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitTest.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitTest.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitTest";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8009"> 
		///		<ExpectedInput>DivisionCode, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8010"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportTransfusion
		/// </summary>
		/// <param name="divisionCode" type="string"></param>
		/// <param name="startDate" type="System.DateTime"></param>
		/// <param name="endDate" type="System.DateTime"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTransfusion(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusion.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusion.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusion.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTransfusion.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8011"> 
		///		<ExpectedInput>Division code, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8012"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from GetExceptionReportTransfusion table used to generate the exception report for a single patient
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTransfusion(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTransfusionForPatient.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8013"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8014"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionTransfusion table used to generate the exception report for a single unit
		/// </summary>
		/// <param name="bloodUnitGuid">blood unit unique id</param>
		/// <returns></returns>
		public static DataSet GetExceptionReportTransfusion(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportTransfusionForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportTransfusionForBloodUnit.StoredProcName, prms);

			ds.DataSetName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportTransfusion.ToString();
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8015"> 
		///		<ExpectedInput>Division code, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8016"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionExpiredTask table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportExpiredTask(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredTask.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredTask.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportExpiredTask.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportExpiredTask.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportExpiredTask";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportExpiredTask";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8017"> 
		///		<ExpectedInput>DivisionCode, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8018"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionEmergencyIssueUnitTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportEmergencyIssueUnitTest(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueUnitTest.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueUnitTest.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueUnitTest.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportEmergencyIssueUnitTest.StoredProcName, prms);
			
			ds.DataSetName = "ExceptionReportEmergencyIssueUnitTest";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportEmergencyIssueUnitTest";
				return ds;
			}
			else
				return new DataSet();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8019"> 
		///		<ExpectedInput>DivisionCode, patient guid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8020"> 
		///		<ExpectedInput>Invalid patient guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionEmergencyIssueUnitTest table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportEmergencyIssueUnitTest(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueUnitTestForPatient.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportEmergencyIssueUnitTestForPatient.patientguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportEmergencyIssueUnitTestForPatient.StoredProcName, prms);
			
			ds.DataSetName = Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString();
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString();
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6491"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6492"> 
		///		<ExpectedInput>Invalid BloodunitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetExceptionReportUnitSupply
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitSupply(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSupplyForBloodUnit.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSupplyForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitSupplyForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitSupplyForBloodUnit";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitSupplyForBloodUnit";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6493"> 
		///		<ExpectedInput>Division Code, Date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6494"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetExceptionReportUnitSupply
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportUnitSupply(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSupply.divisioncode, SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSupply.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetExceptionReportUnitSupply.enddate, SqlDbType.DateTime)
								  };

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportUnitSupply.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportUnitSupply";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportUnitSupply";
				return ds;
			}
			else
				return new DataSet();
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/27/2005</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="6620"> 
		///		<ExpectedInput>Division code, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6621"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from PatientRestriction table used to generate the exception report
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientRestriction(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
			{
				new SqlParameter(STOREDPROC.GetExceptionReportPatientRestriction.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetExceptionReportPatientRestriction.startdate, SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetExceptionReportPatientRestriction.enddate, SqlDbType.DateTime)				  
			};

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;
			
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientRestriction.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientRestriction";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientRestriction";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8021"> 
		///		<ExpectedInput>Division Code, PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8022"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetExceptionReportPatientRestriction
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportPatientRestriction(string divisionCode, Guid patientGuid)
		{
			SqlParameter[] prms = 
			{
				new SqlParameter(STOREDPROC.GetExceptionReportPatientRestrictionForPatient.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetExceptionReportPatientRestrictionForPatient.patientguid, SqlDbType.UniqueIdentifier)			  
			};

			prms[0].Value = divisionCode;
			prms[1].Value = patientGuid;
			
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportPatientRestrictionForPatient.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportPatientRestriction";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportPatientRestriction";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8023"> 
		///		<ExpectedInput>Division code, date range</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8024"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get exception report for inconclusive crossmatch
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportInconclusiveCrossmatch(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
			{
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.startdate, SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.enddate, SqlDbType.DateTime)
			};

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportInconclusiveCrossmatch";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportInconclusiveCrossmatch";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2005</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="8343"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet with Data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8344"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the data from ExceptionExpiredUnitReceived table 
		/// used to generate the exception report
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportExpiredUnitReceived(Guid bloodUnitGuid)
		{
			SqlParameter[] prms = 
			{
				new SqlParameter(STOREDPROC.GetExceptionReportExpiredUnitReceivedForBloodUnit.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetExceptionReportExpiredUnitReceivedForBloodUnit.bloodunitguid, SqlDbType.UniqueIdentifier)
			};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = bloodUnitGuid;
			
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportExpiredUnitReceivedForBloodUnit.StoredProcName, prms);

			ds.DataSetName = "GetExceptionReportExpiredUnitReceived";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "GetExceptionReportExpiredUnitReceived";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}

		/// <summary>
		/// Get exception report for electronic transfusion
		/// CR 2942
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataSet GetExceptionReportElectronicTransfusion(string divisionCode, DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
			{
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.startdate, SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetExceptionReportInconclusiveCrossmatch.enddate, SqlDbType.DateTime)
			};

			prms[0].Value = divisionCode;
			prms[1].Value = startDate;
			prms[2].Value = endDate;

			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetExceptionReportElectronicTransfusion.StoredProcName, prms);

			ds.DataSetName = "ExceptionReportElectronicTransfusion";
			if (ds.Tables.Count > 0)
			{
				ds.Tables[0].TableName = "ExceptionReportElectronicTransfusion";
				return ds;
			}
			else
			{
				return new DataSet();
			}
		}
	}
}
